//
//  CRCICanvas.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 6/2/09.
//  Copyright 2009 Corner-A. All rights reserved.
//

#import "CRCIImagePart.h"

//////////////////////////////////////////////////////////////////////
// Simple hardware-accelerated canvas based on CIImageAccumulator,
// supports undo, coding and copying since it can be a part of more
// complex object (for example, this is used as a mask in the
// PhotoStyler filters)
//////////////////////////////////////////////////////////////////////
@interface CRCICanvas : NSObject <NSCoding, NSCopying>
{
	CGRect				extent;
	
	// images
	CIImageAccumulator* prepaintState;
	CIImageAccumulator* imageAccumulator;
	
	BOOL				editQueried;
	NSMutableArray*		dirtyArea;
}

@property (nonatomic, assign)	CGRect				inputRect;			// or this rect is used to determine the canvas size
@property (nonatomic, readonly)	CIImage*			outputImage;		// output image
@property (nonatomic, readonly)	CIImageAccumulator* imageAccumulator;	// background image accumulator
@property (nonatomic, readonly)	BOOL				editQueried;		// signal whrether edit was ever queried
@property (nonatomic, assign)	BOOL				immediateUpdate;	// signals whether update singnal is sent right twhen the maks is drawn

+ (id)canvas;

- (void)beginPaint;
- (CRCIImagePart *)endPaint;

- (void)shrink;
- (void)discardOutput;
- (void)accumulateImage:(CIImage *)image dirtyRect:(NSRect)rect;
- (void)saveReversePart:(CRCIImagePart *)reversePart andRegisterAction:(NSUndoManager *)undoManager;

@end